<?php
require_once 'config.php';

header('Content-Type: application/json; charset=UTF-8');
$conn = get_db_connection();

$sql = "SELECT version_code, version_name, update_url, update_message, force_update FROM app_version ORDER BY id DESC LIMIT 1";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $version = $result->fetch_assoc();
    
    // force_update মানকে BOOLEAN এ কনভার্ট করুন
    $version['force_update'] = (bool)$version['force_update'];
    
    echo json_encode($version, JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode(['error' => 'No version info found']);
}

$conn->close();
?>
