<?php
// Include the database configuration file
require_once 'config.php';

// Check if refer_code is provided in POST request
if (isset($_POST['refer_code'])) {
    $refer_code = $_POST['refer_code'];

    // Get the database connection
    $connection = get_db_connection();

    // Use prepared statements to prevent SQL injection
    $sql = "SELECT name FROM user_data WHERE refer_code = ?";
    $stmt = $connection->prepare($sql);
    $stmt->bind_param("s", $refer_code);

    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Fetch the name from the result
        $row = $result->fetch_assoc();
        echo json_encode(['status' => 'success', 'name' => $row['name']]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Refer code not found']);
    }

    // Close statement and connection
    $stmt->close();
    $connection->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Refer code is missing']);
}
?>

