<?php
// Database connection
require_once 'config.php';

$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];

    // Update account_status to 'deleting'
    $sqlUpdate = "UPDATE user_data SET account_status='deleting' WHERE email=?";
    $stmt = $conn->prepare($sqlUpdate);
    $stmt->bind_param("s", $email); // Use "s" for string type

    if ($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Account status updated to deleting"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to update account status"]);
    }

    $stmt->close();
    $conn->close();
}
?>

