<?php
require_once 'config.php';

$conn = get_db_connection();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'] ?? null;
    $image = $_FILES['image'] ?? null;

    if ($name && $image) {
        $target_dir = "uploads/";
        $target_file = $target_dir . basename($image["name"]);
        
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

        if (move_uploaded_file($image["tmp_name"], $target_file)) {
            $base_url = BASE_URL . "district_info/";
            $image_url = $base_url . $target_file;
            
            $stmt = $conn->prepare("INSERT INTO main_categories (name, image) VALUES (?, ?)");
            $stmt->bind_param("ss", $name, $image_url);

            if ($stmt->execute()) {
                echo json_encode(["message" => "Category added successfully"]);
            } else {
                echo json_encode(["message" => "Failed to add category"]);
            }

            $stmt->close();
        } else {
            echo json_encode(["message" => "Failed to upload image"]);
        }
    } else {
        echo json_encode(["message" => "Required fields are missing"]);
    }
}

$conn->close();
?>
