<?php
header('Content-Type: application/json');

// Database connection details
require_once 'config.php';

// Create connection
$conn = get_db_connection();

// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Debugging: Check if connection is successful
if ($conn->connect_error) {
    die(json_encode(['status' => 'error', 'message' => 'Database connection failed: ' . $conn->connect_error]));
}

$product_id = $_POST['product_id'];
$title = $_POST['title'];
$description = $_POST['description'];
$address = $_POST['address'];
$number = $_POST['number'];
$features = $_POST['features'];

// Set upload folder path
$image_folder = 'uploads/';
$baseurl = BASE_URL . 'district_info/uploads/';
$image_url = ""; // URL to be stored in the database

if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != "") {
    $image_name = $_FILES['image']['name'];
    $image_tmp_name = $_FILES['image']['tmp_name'];
    $local_image_path = $image_folder . $image_name; // Local path for server storage
    $image_url = $baseurl . $image_name; // URL to be stored in the database

    // Move uploaded file to the server
    if (!move_uploaded_file($image_tmp_name, $local_image_path)) {
        echo json_encode(['status' => 'error', 'message' => 'Failed to upload image']);
        exit;
    }
}

// Prepare the SQL statement
$sql = "UPDATE district_info SET title=?, description=?, address=?, number=?, features=?";
if (!empty($image_url)) {
    $sql .= ", thumbnail=?";
}
$sql .= " WHERE id=?";

// Prepare and bind parameters
$stmt = $conn->prepare($sql);
if ($stmt === false) {
    echo json_encode(['status' => 'error', 'message' => 'Prepare failed: ' . $conn->error]);
    exit;
}

if (!empty($image_url)) {
    $stmt->bind_param('ssssssi', $title, $description, $address, $number, $features, $image_url, $product_id);
} else {
    $stmt->bind_param('sssssi', $title, $description, $address, $number, $features, $product_id);
}

// Execute the statement and check for errors
if ($stmt->execute()) {
    $response = [
        'status' => 'success',
        'message' => 'Product updated successfully'
    ];
} else {
    $response = [
        'status' => 'error',
        'message' => 'Failed to update product: ' . $stmt->error
    ];
}

echo json_encode($response);

$stmt->close();
$conn->close();
?>
