<?php
require_once 'config.php';

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Connection failed: " . $conn->connect_error]));
}

// Get the item_status from the request (Pending or Accept)
$item_status = $_POST['item_status'] ?? null;
$id = $_POST['id'] ?? null;

if (!$item_status || !$id) {
    die(json_encode(["status" => "error", "message" => "Missing required parameters."]));
}

// If item_status is Pending
if ($item_status == 'Pending') {
    // Update user_info item_status to 'Pending'
    $stmt = $conn->prepare("UPDATE user_info SET item_status = ? WHERE id = ?");
    $stmt->bind_param("si", $item_status, $id);
    
    if ($stmt->execute()) {
        // Delete existing record from district_info if exists
        $delete_stmt = $conn->prepare("DELETE FROM district_info WHERE user_id = ?");
        $delete_stmt->bind_param("i", $id);
        $delete_stmt->execute();

        echo json_encode(["status" => "success", "message" => "Record updated to Pending successfully and related district_info deleted."]);
        $delete_stmt->close();
    } else {
        echo json_encode(["status" => "error", "message" => "Error updating record: " . $stmt->error]);
    }
    $stmt->close();
    $conn->close();
    exit();
}

// If item_status is Accept
if ($item_status == 'Accept') {
    $stmt = $conn->prepare("SELECT * FROM user_info WHERE item_status = 'Pending' AND id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            // Prepare the data for insertion into district_info
            $title = $row['title'];
            $description = $row['description'];
            $thumbnail = $row['thumbnail'];
            $address = $row['address'];
            $number = $row['number'];
            $category_id = $row['category_id'];
            $features = $row['features'];

            // Check if the record already exists in district_info
            $check_stmt = $conn->prepare("SELECT * FROM district_info WHERE user_id = ?");
            $check_stmt->bind_param("i", $id);
            $check_stmt->execute();
            $check_result = $check_stmt->get_result();

            if ($check_result->num_rows > 0) {
                // Update existing record
                $update_stmt = $conn->prepare("UPDATE district_info SET title = ?, description = ?, thumbnail = ?, address = ?, number = ?, category_id = ?, features = ? WHERE user_id = ?");
                $update_stmt->bind_param("sssssssi", $title, $description, $thumbnail, $address, $number, $category_id, $features, $id);

                if ($update_stmt->execute()) {
                    echo json_encode(["status" => "success", "message" => "Record updated successfully in district_info"]);
                } else {
                    echo json_encode(["status" => "error", "message" => "Error updating record: " . $update_stmt->error]);
                }
                $update_stmt->close();
            } else {
                // Insert new record
                $insert_stmt = $conn->prepare("INSERT INTO district_info (title, description, thumbnail, address, number, category_id, features, user_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                $insert_stmt->bind_param("sssssssi", $title, $description, $thumbnail, $address, $number, $category_id, $features, $id);

                if ($insert_stmt->execute()) {
                    echo json_encode(["status" => "success", "message" => "Record transferred successfully to district_info"]);
                } else {
                    echo json_encode(["status" => "error", "message" => "Error inserting record: " . $insert_stmt->error]);
                }
                $insert_stmt->close();
            }
            $check_stmt->close();

            // Update item_status to 'Accepted' after successful transfer
            $update_status_stmt = $conn->prepare("UPDATE user_info SET item_status = 'Accepted' WHERE id = ?");
            $update_status_stmt->bind_param("i", $id);
            $update_status_stmt->execute();
            $update_status_stmt->close();
        }
    } else {
        echo json_encode(["status" => "error", "message" => "No records with 'Pending' status found for the given ID."]);
    }
}

$conn->close();
?>
