<?php
require_once 'config.php';

$conn = get_db_connection();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'] ?? null;
    $name = $_POST['name'] ?? null;
    $image = $_FILES['image'] ?? null;

    if ($id && $name) {
        if ($image && $image['size'] > 0) {
            $target_dir = "uploads/";
            $target_file = $target_dir . basename($image["name"]);
            $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

            if (move_uploaded_file($image["tmp_name"], $target_file)) {
                $base_url = BASE_URL . "district_info/";
                $image_url = $base_url . $target_file;

                $stmt = $conn->prepare("UPDATE main_categories SET name = ?, image = ? WHERE id = ?");
                $stmt->bind_param("ssi", $name, $image_url, $id);
            } else {
                echo json_encode(["message" => "Failed to upload image"]);
                exit;
            }
        } else {
            // যদি কোনো নতুন ছবি না আসে, শুধুমাত্র নাম আপডেট করুন
            $stmt = $conn->prepare("UPDATE main_categories SET name = ? WHERE id = ?");
            $stmt->bind_param("si", $name, $id);
        }

        if ($stmt->execute()) {
            echo json_encode(["message" => "Category updated successfully"]);
        } else {
            echo json_encode(["message" => "Database error"]);
        }

        $stmt->close();
    } else {
        echo json_encode(["message" => "Required fields are missing"]);
    }
}

$conn->close();
?>
