<?php
// Database configuration
require_once 'config.php';

$baseURL = BASE_URL . 'district_info/';

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the POST data
    $id = $_POST['id'];
    $title = $_POST['title'];
    $description = $_POST['description'];
    $address = $_POST['address'];
    $number = $_POST['number'];
    $thumbnail = $_POST['thumbnail'];  // This could be the URL of the uploaded image or Base64 encoded image data

    // Initialize $imageURL variable
    $imageURL = '';

    // Check if $thumbnail is a Base64 string or just an existing URL
    if (strpos($thumbnail, 'data:image') === 0) {
        // Decode image from Base64
        $imageData = base64_decode($thumbnail);
        $imageName = uniqid() . '.jpg';
        $imagePath = 'uploads/' . $imageName;

        // Save image to server
        if (file_put_contents($imagePath, $imageData)) {
            // Concatenate the base URL with the image name
            $imageURL = $baseURL . $imagePath;
        } else {
            echo json_encode(["status" => "error", "message" => "Failed to save image to server."]);
            $conn->close();
            exit;
        }
    } else {
        // If $thumbnail is not a Base64 string, it means the user did not change the image
        // Use the existing thumbnail URL
        $imageURL = $thumbnail;
    }

    // SQL query to update the information
    $sql = "UPDATE user_info SET 
            title = '$title', 
            description = '$description', 
            address = '$address', 
            number = '$number', 
            thumbnail = '$imageURL',
            item_status = 'Pending'  -- Update item_status to Pending
            WHERE id = $id";

    if ($conn->query($sql) === TRUE) {
        echo json_encode(["status" => "success", "message" => "Record updated successfully"]);

        // Check if a record with this ID exists in district_info and delete it if found
        $delete_sql = "DELETE FROM district_info WHERE user_id = $id";
        if ($conn->query($delete_sql) === TRUE) {
            echo json_encode(["status" => "success", "message" => "Record deleted from district_info"]);
        } else {
            echo json_encode(["status" => "error", "message" => "Error deleting record from district_info: " . $conn->error]);
        }

    } else {
        echo json_encode(["status" => "error", "message" => "Error updating record: " . $conn->error]);
    }
}

$conn->close();
?>
