<?php
require_once 'config.php';

$baseURL = BASE_URL . 'district_info/';

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$response = array();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $_POST['title'];
    $description = $_POST['description'];
    $address = $_POST['address'];
    $contact = $_POST['contact'];
    $category = $_POST['category'];
    $item_status = $_POST['item_status'];
    $features = $_POST['features'];
    $useremail = $_POST['email'];
    $image = $_POST['image'];

    // Decode image from Base64
    $imageData = base64_decode($image);
    $imageName = uniqid() . '.jpg';
    $imagePath = 'uploads/' . $imageName;

    // Save image to server
    if (file_put_contents($imagePath, $imageData)) {
        // Concatenate the base URL with the image name
        $imageURL = $baseURL . $imagePath;

        // Prepare and execute the SQL statement
        $stmt = $conn->prepare("INSERT INTO user_info (title, description, address, number, category_id, features, email, item_status, thumbnail) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        if ($stmt) {
            $stmt->bind_param("sssssssss", $title, $description, $address, $contact, $category, $features, $useremail, $item_status, $imageURL);

            if ($stmt->execute()) {
                $response['success'] = "1";
                $response['message'] = "Information added successfully";
            } else {
                $response['success'] = "0";
                $response['message'] = "Failed to add information";
            }

            $stmt->close();
        } else {
            $response['success'] = "0";
            $response['message'] = "Failed to prepare statement";
        }
    } else {
        $response['success'] = "0";
        $response['message'] = "Failed to save image";
    }

    $conn->close();
} else {
    $response['success'] = "0";
    $response['message'] = "Invalid request";
}

echo json_encode($response);
?>
