<?php
require_once 'config.php';

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the category ID from the request, if available
$category_id = isset($_GET['category_id']) ? intval($_GET['category_id']) : 0;

if ($category_id > 0) {
    // Prepare and execute SQL statement to fetch products based on category_id
    $stmt = $conn->prepare("SELECT * FROM products WHERE category_id = ?");
    $stmt->bind_param("i", $category_id);
} else {
    // Fetch all products if no category_id is provided
    $stmt = $conn->prepare("SELECT * FROM products");
}

$stmt->execute();
$result = $stmt->get_result();

$products = array();

// Fetch product data
while ($row = $result->fetch_assoc()) {
    $products[] = $row;
}

// Return the products as a JSON array
echo json_encode($products);

$stmt->close();
$conn->close();
?>