<?php
// Database configuration
require_once 'config.php';

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the POST data
$postData = file_get_contents('php://input');
$request = json_decode($postData, true);

$order_id = $request['order_id'];

// Validate the input
if (empty($order_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Order ID is required']);
    exit();
}

// Update the order status to "Canceled"
$sql = "UPDATE orders SET order_status = 'Canceled' WHERE order_id = ? AND order_status = 'Pending'";

$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $order_id);

if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Order canceled successfully']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Order not found or already processed']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to cancel order']);
}

// Close connection
$stmt->close();
$conn->close();
?>
