<?php
require_once 'config.php';

// Enable error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    error_log("Connection failed: " . $conn->connect_error);
    http_response_code(500);
    die(json_encode(array("error" => "Database connection failed")));
}

// Check if order_id is provided
if (!isset($_GET['order_id'])) {
    error_log("order_id not provided");
    http_response_code(400);
    die(json_encode(array("error" => "order_id not provided")));
}

$order_id = $_GET['order_id']; // Get the order id from the request

$sql = "SELECT order_id, order_amount, product_name, product_size, product_image, product_price, product_quantity FROM order_products WHERE order_id = ?";
$stmt = $conn->prepare($sql);

// Check if the statement was prepared correctly
if ($stmt === false) {
    error_log("Failed to prepare statement: " . $conn->error);
    http_response_code(500);
    die(json_encode(array("error" => "Failed to prepare statement")));
}

$stmt->bind_param("s", $order_id);
$stmt->execute();
$result = $stmt->get_result();

// Check if the query was successful
if ($result === false) {
    error_log("Failed to execute query: " . $stmt->error);
    http_response_code(500);
    die(json_encode(array("error" => "Failed to execute query")));
}

$orders = array();

while ($row = $result->fetch_assoc()) {
    $orders[] = $row;
}

$stmt->close();
$conn->close();

header('Content-Type: application/json');
echo json_encode($orders);
?>
