<?php
// Set JSON headers for the API response
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Include the config file for database configuration
require_once 'config.php';

try {
    // Use the PDO connection with constants from config.php
    $dsn = "mysql:host=" . DB_SERVER . ";dbname=" . DB_NAME . ";charset=utf8mb4";
    $pdo = new PDO($dsn, DB_USERNAME, DB_PASSWORD, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

// Validate and sanitize the email parameter from the request
$email = filter_var($_GET['email'] ?? '', FILTER_VALIDATE_EMAIL);

if (empty($email)) {
    http_response_code(400);
    echo json_encode(['error' => 'Email parameter is missing or invalid']);
    exit;
}

// Prepare and execute the SQL query to fetch orders
$sql = "SELECT * FROM orders WHERE customer_email = ? ORDER BY id DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute([$email]);

// Fetch all orders and return them as a JSON response
$orders = $stmt->fetchAll();
echo json_encode($orders);
?>
