<?php
require_once 'config.php';
$baseURL = BASE_URL . "e-commerce/";

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if all required parameters are set
if (!isset($_POST['product_id'], $_POST['name'], $_POST['description'], $_POST['price'], $_POST['sizes'])) {
    echo json_encode(array("status" => "error", "message" => "Missing required parameter"));
    $conn->close();
    exit();
}

// Prepare variables
$productID = $_POST['product_id'];
$name = $_POST['name'];
$description = $_POST['description'];
$price = $_POST['price'];
$sizes = $_POST['sizes'];

// Log received data
file_put_contents('php://stderr', print_r("Received Data: ID=$productID, Name=$name, Description=$description, Price=$price, Sizes=$sizes\n", true));

$image = null;
if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
    $target_dir = "uploads/";
    $target_file = $target_dir . basename($_FILES["image"]["name"]);
    $imageURL = $baseURL . $target_file; // Combine baseURL with target_file for image URL

    if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
        $image = $imageURL; // Store image URL instead of file path
    } else {
        echo json_encode(array("status" => "error", "message" => "Failed to move uploaded file."));
        $conn->close();
        exit();
    }
} else if (isset($_FILES['image']) && $_FILES['image']['error'] != 0) {
    echo json_encode(array("status" => "error", "message" => "File upload error: " . $_FILES['image']['error']));
    $conn->close();
    exit();
}

// Update product in database
$sql = "UPDATE products SET name=?, description=?, price=?, sizes=?";
if ($image !== null) {
    $sql .= ", image=?";
}
$sql .= " WHERE id=?";

$stmt = $conn->prepare($sql);

if ($image !== null) {
    $stmt->bind_param("sssssi", $name, $description, $price, $sizes, $image, $productID);
} else {
    $stmt->bind_param("ssssi", $name, $description, $price, $sizes, $productID);
}

if ($stmt->execute()) {
    echo json_encode(array("status" => "success", "message" => "Product updated successfully"));
} else {
    echo json_encode(array("status" => "error", "message" => "Error updating product: " . $stmt->error));
}

// Log SQL execution result
file_put_contents('php://stderr', print_r("SQL Execution: " . ($stmt->execute() ? "Success" : "Error: " . $stmt->error) . "\n", true));

$stmt->close();
$conn->close();
?>
