<?php
// submit_order.php

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Include the config file
require_once 'config.php';

try {
    // Create a PDO connection using the config.php constants
    $dsn = "mysql:host=" . DB_SERVER . ";dbname=" . DB_NAME . ";charset=utf8mb4";
    $pdo = new PDO($dsn, DB_USERNAME, DB_PASSWORD, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ]);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

// Retrieve JSON input and decode it
$data = json_decode(file_get_contents('php://input'), true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['error' => 'Invalid JSON input']);
    exit;
}

// Validate input data
$required_fields = [
    'order_id', 'order_date_time', 'customer_name', 'customer_number', 
    'customer_address', 'sub_total_amount', 'delivery_charge', 
    'total_amount', 'payment_method', 'customer_email'
];

foreach ($required_fields as $field) {
    if (empty($data[$field])) {
        echo json_encode(['error' => 'Missing required field: ' . $field]);
        exit;
    }
}

// Prepare the SQL statement for inserting the order
$sql = "INSERT INTO orders (
    order_id, order_date_time, customer_name, customer_number, 
    customer_address, sub_total_amount, delivery_charge, 
    total_amount, payment_method, customer_email
) VALUES (
    :order_id, :order_date_time, :customer_name, :customer_number, 
    :customer_address, :sub_total_amount, :delivery_charge, 
    :total_amount, :payment_method, :customer_email
)";

$stmt = $pdo->prepare($sql);

try {
    // Execute the prepared statement with input data
    $stmt->execute([
        'order_id' => $data['order_id'],
        'order_date_time' => $data['order_date_time'],
        'customer_name' => $data['customer_name'],
        'customer_number' => $data['customer_number'],
        'customer_address' => $data['customer_address'],
        'sub_total_amount' => $data['sub_total_amount'],
        'delivery_charge' => $data['delivery_charge'],
        'total_amount' => $data['total_amount'],
        'payment_method' => $data['payment_method'],
        'customer_email' => $data['customer_email']
    ]);

    echo json_encode(['success' => 'Order submitted successfully']);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Failed to submit order: ' . $e->getMessage()]);
}
?>
