<?php
require_once 'config.php';

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Read JSON input
$products_data = json_decode(file_get_contents('php://input'), true);

foreach ($products_data as $product) {
    // Prepare and bind
    $stmt = $conn->prepare("INSERT INTO order_products (order_id, product_name, product_size, product_image, product_price, product_quantity, order_amount) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssdis", $product['order_id'], $product['product_name'], $product['product_size'], $product['product_image'], $product['product_price'], $product['product_quantity'], $product['order_amount']);
    
    if (!$stmt->execute()) {
        echo json_encode(["status" => "error", "message" => "Failed to submit product"]);
        $stmt->close();
        $conn->close();
        exit();
    }
}

echo json_encode(["status" => "success", "message" => "Products submitted successfully"]);

$stmt->close();
$conn->close();
?>
