<?php
require_once 'config.php';

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    error_log("Connection failed: " . $conn->connect_error);
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $id = $_POST["id"];
    $name = $_POST["name"];
    $image = $_FILES["image"];

    // Log received data
    error_log("Received data - ID: $id, Name: $name, Image: " . print_r($image, true));

    // Use prepared statement to prevent SQL injection for updating category name
    $stmt = $conn->prepare("UPDATE categories SET name = ? WHERE id = ?");
    if ($stmt === false) {
        error_log("Prepare failed: " . $conn->error);
        die("Error preparing statement");
    }
    $stmt->bind_param("si", $name, $id);

    if ($stmt->execute() === TRUE) {
        $imageUpdated = false;

        // Check if an image file is uploaded
        if ($image && $image["error"] == 0) {
            $base_url = BASE_URL . "e-commerce/";
            $target_dir = "uploads/";

            // File path to save in the database
            $target_file = $target_dir . basename($image["name"]);
            $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

            // Log file details
            error_log("File details - Target File: $target_file, File Type: $imageFileType, File Size: " . $image["size"]);

            // Check file size (limit to 2MB)
            if ($image["size"] > 2000000) {
                error_log("File too large.");
                echo "Sorry, your file is too large.";
                exit();
            }

            // Allow certain file formats
            $allowedFormats = array("jpg", "jpeg", "png", "gif");
            if (!in_array($imageFileType, $allowedFormats)) {
                error_log("Invalid file format.");
                echo "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
                exit();
            }

            // Upload file
            if (move_uploaded_file($image["tmp_name"], $target_file)) {
                // Full URL to save in the database
                $full_url = $base_url . $target_file;

                // Update the image path in the database
                $stmt = $conn->prepare("UPDATE categories SET image = ? WHERE id = ?");
                if ($stmt === false) {
                    error_log("Prepare failed: " . $conn->error);
                    die("Error preparing statement");
                }
                $stmt->bind_param("si", $full_url, $id);

                if ($stmt->execute() === TRUE) {
                    $imageUpdated = true;
                } else {
                    error_log("Error updating image path: " . $stmt->error);
                    echo "Error updating image path: " . $stmt->error;
                    exit();
                }
            } else {
                error_log("Error uploading file: " . print_r($image, true));
                echo "Sorry, there was an error uploading your file.";
                exit();
            }
        }

        if ($imageUpdated) {
            error_log("Category updated successfully with image.");
            echo "Category updated successfully with image.";
        } else {
            error_log("Category updated successfully.");
            echo "Category updated successfully.";
        }
    } else {
        error_log("Error updating category name: " . $stmt->error);
        echo "Error updating category name: " . $stmt->error;
    }

    $stmt->close();
}

$conn->close();
?>
