<?php
header('Content-Type: application/json');

// Database credentials
require_once 'config.php';

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die(json_encode(['status' => 'error', 'message' => 'Database connection failed: ' . $conn->connect_error]));
}

// Check if POST data is received
$postData = file_get_contents("php://input");
if (!$postData) {
    echo json_encode(['status' => 'error', 'message' => 'POST data not received. Check your request.']);
    exit;
}

// Decode the JSON data
$data = json_decode($postData, true);

// Validate received data
if (!isset($data['email']) || !isset($data['fcm_token'])) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid input. Email and FCM token are required.']);
    exit;
}

$email = strtolower(trim($data['email']));
$fcm_token = trim($data['fcm_token']);

// Log received email and token for debugging (optional)
file_put_contents('debug_log.txt', "Received Email: " . $email . " - Received Token: " . $fcm_token . "\n", FILE_APPEND);

// Prepare and execute query to check if the email exists
$sql_check = "SELECT email FROM user_data WHERE LOWER(email) = ?";
$stmt_check = $conn->prepare($sql_check);
$stmt_check->bind_param('s', $email);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

if ($result_check->num_rows > 0) {
    // Email exists, proceed to update the FCM token
    $sql_update = "UPDATE user_data SET fcmToken = ? WHERE LOWER(email) = ?";
    $stmt_update = $conn->prepare($sql_update);
    $stmt_update->bind_param('ss', $fcm_token, $email);

    if ($stmt_update->execute()) {
        if ($stmt_update->affected_rows > 0) {
            echo json_encode(['status' => 'success', 'message' => 'FCM token updated successfully']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No rows were updated.']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update FCM token: ' . $stmt_update->error]);
    }

    $stmt_update->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Email not found in database.']);
}

$stmt_check->close();
$conn->close();
?>
