<?php
header("Content-Type: application/json");

require_once 'config.php';

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the posted data
$data = json_decode(file_get_contents('php://input'), true);
$order_id = $data['order_id'];
$order_status = $data['order_status'];

// Update order status
$sql = "UPDATE orders SET order_status = ? WHERE order_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $order_status, $order_id);

if ($stmt->execute()) {
    echo json_encode(["message" => "Order status updated successfully"]);
} else {
    echo json_encode(["message" => "Failed to update order status", "error" => $stmt->error]);
}

$stmt->close();
$conn->close();
?>
