<?php
require_once 'config.php';

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$response = array();

$tables = array(
    "categories" => "total_category_count",
    "orders" => "total_sale_count",
    "order_products" => "total_order_product_count",
    "products" => "total_product_count",
    "user_data" => "total_user_count",
    "main_categories" => "total_main_category_count",
    "user_info" => "total_user_information_count",
    "district_info" => "total_information_count"
);

foreach ($tables as $table => $key) {
    $sql = "SELECT COUNT(*) AS count FROM $table";
    $result = $conn->query($sql);
    if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $response[$key] = $row["count"];
        }
    } else {
        $response[$key] = 0;
    }
}

$conn->close();

echo json_encode($response);
?>
