<?php
require_once 'config.php';
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    // Database connection
    $conn = get_db_connection();

    // Check connection
    if ($conn->connect_error) {
        die(json_encode(["status" => "error", "message" => "Database connection failed: " . $conn->connect_error]));
    }

    // Assuming you have a unique identifier (like `id`) to fetch the correct record
    $id = 1; // Replace with the actual ID of the record you want to fetch

    // Prepare and execute the query
    $stmt = $conn->prepare("SELECT email, facebook, whatsapp FROM contacts WHERE id = ?");
    $stmt->bind_param("i", $id); // "i" denotes the type is integer
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode(["status" => "success", "data" => $row]);
    } else {
        echo json_encode(["status" => "error", "message" => "No contact information found"]);
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request"]);
}
?>
