<?php
// Database connection
require_once 'config.php';
$conn = get_db_connection();

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get email from request
$email = $_GET['email'];

// Prepare and execute SQL query
$stmt = $conn->prepare("SELECT refer_code, total_refer FROM user_data WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($refer_code, $total_refer);

// Fetch and return data
$response = [];
if ($stmt->fetch()) {
    $response['refer_code'] = $refer_code;
    $response['total_refer'] = $total_refer;
} else {
    $response['error'] = "User not found";
}

$stmt->close();
$conn->close();

// Return JSON response
header('Content-Type: application/json');
echo json_encode($response);
?>
