<?php
// Database configuration
require_once 'config.php';

// Create a connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if email parameter is provided
if (isset($_GET['email'])) {
    $email = $_GET['email'];
    
    // Escape the email to prevent SQL injection
    $email = $conn->real_escape_string($email);

    // SQL query to fetch all wallet data for the specific user
    $sql = "SELECT user_email, credit, debit, balance, transection_type, created_at 
            FROM wallet 
            WHERE user_email = '$email'";
    $result = $conn->query($sql);

    // Initialize an empty array to store the wallet data
    $wallets = array();
    $total_balance = 0;

    if ($result->num_rows > 0) {
        // Loop through the result and store each row in the wallets array
        while($row = $result->fetch_assoc()) {
            $wallets[] = $row;
            // Update total_balance with the most recent balance
            $total_balance = $row['balance'];
        }
        
        // Include total_balance in the final output
        $response = array(
            'wallets' => $wallets,
            'total_balance' => $total_balance
        );
        
        // Return the data as JSON
        echo json_encode($response);
    } else {
        // If no data found, return an empty array with total_balance as 0
        echo json_encode([
            'wallets' => [],
            'total_balance' => 0
        ]);
    }
} else {
    echo json_encode(['error' => 'Email parameter missing']);
}

// Close the connection
$conn->close();
?>
