<?php
// ডাটাবেজ সংযোগ ফাংশন
require_once 'config.php';
function getDbConnection() {
    
    // সংযোগ তৈরি করা
    $conn = get_db_connection();
    
    // সংযোগ যাচাই করা
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    return $conn;
}

// ইমেইল যাচাই ও ব্যালেন্স আপডেট ফাংশন
function updateTransaction($email, $credit) {
    $conn = getDbConnection();
    
    // সর্বশেষ ব্যালেন্স খুঁজে বের করা
    $stmt = $conn->prepare("SELECT balance FROM wallet WHERE user_email = ? ORDER BY created_at DESC LIMIT 1");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        // ইমেইল পাওয়া গেলে ব্যালেন্স আপডেট
        $row = $result->fetch_assoc();
        $currentBalance = $row['balance'];
        $newBalance = $currentBalance + $credit;
    } else {
        // ইমেইল না থাকলে নতুন রেকর্ড তৈরি
        $newBalance = $credit;
    }
    
    // ট্রানজেকশন এড করা
    $stmt = $conn->prepare("INSERT INTO wallet (user_email, credit, balance, transection_type, created_at) VALUES (?, ?, ?, 'এড মানি করেছেন !', NOW())");
    $stmt->bind_param("sii", $email, $credit, $newBalance);
    $stmt->execute();
    
    $stmt->close();
    $conn->close();
}

// API থেকে POST ডেটা গ্রহণ করা
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'];
    $credit = $_POST['credit'];
    
    updateTransaction($email, $credit);
    
    echo json_encode(["message" => "Transaction updated successfully."]);
}
?>
