<?php
require_once 'config.php';

$email = $_POST['email'];
$password = $_POST['password'];

$connect = get_db_connection();

if (!$connect) {
    echo json_encode(array('status' => 'error', 'message' => 'Database Connection Failed: ' . mysqli_connect_error()));
    exit();
}

// Sanitize email to prevent SQL injection
$email = mysqli_real_escape_string($connect, $email);

// Query to retrieve user data based on email
$query = "SELECT * FROM user_data WHERE email = '$email'";
$result = mysqli_query($connect, $query);

if ($result) {
    if (mysqli_num_rows($result) > 0) {
        $user_data = mysqli_fetch_assoc($result);
        $storedPasswordHash = $user_data['password'];
        $accountStatus = $user_data['account_status']; // Assuming 'account_status' column exists

        // Check account status
        if ($accountStatus === 'deleting') {
            echo json_encode(array('status' => 'error', 'message' => 'Account is marked for deletion'));
        } else {
            // Verify the entered password against the stored hashed password
            if (password_verify($password, $storedPasswordHash)) {
                $response = array(
                    'status' => 'success',
                    'image' => $user_data['image'],  // Assuming 'image' column exists
                    'name' => $user_data['name'],    // Assuming 'name' column exists
                    'email' => $user_data['email'],
                    'phone' => $user_data['phone'],  // Assuming 'phone' column exists
                    'address' => $user_data['address'],
                );
                echo json_encode($response);
            } else {
                echo json_encode(array('status' => 'error', 'message' => 'Invalid email or password'));
            }
        }
    } else {
        echo json_encode(array('status' => 'error', 'message' => 'Invalid email or password'));
    }
} else {
    echo json_encode(array('status' => 'error', 'message' => 'Login Failed: ' . mysqli_error($connect)));
}

mysqli_close($connect);
?>

