<?php
// Database connection details
require_once 'config.php';

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die(json_encode(array("error" => "Connection failed: " . $conn->connect_error)));
}

// Query to get the payment settings for a specific ID (e.g., id = 1)
$sql = "SELECT status, api_key, api_sicret, user_id, user_pw FROM payment_settings WHERE id = 1";
$result = $conn->query($sql);

if ($result === false) {
    // Handle SQL error
    die(json_encode(array("error" => "SQL error: " . $conn->error)));
}

if ($result->num_rows > 0) {
    // Fetch and output data in JSON format
    $row = $result->fetch_assoc();
    echo json_encode(array(
        'status' => $row['status'], 
        'api_key' => $row['api_key'],
        'api_sicret' => $row['api_sicret'],
        'user_id' => $row['user_id'],
        'user_pw' => $row['user_pw']
    ));
} else {
    // Handle case when no rows are returned
    echo json_encode(array(
        'status' => 'off', 
        'api_key' => '', 
        'api_sicret' => '', 
        'user_id' => '', 
        'user_pw' => ''
    ));
}

// Close the connection
$conn->close();
?>
