<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if content is set
    if (isset($_POST['content'])) {
        // Fetch the content from the POST request
        $raw_content = $_POST['content'];
        
        // Decode HTML entities (in case any encoded content is received)
        $decoded_content = html_entity_decode($raw_content, ENT_QUOTES, 'UTF-8');
        
        // Process the content with htmlspecialchars to avoid any XSS attacks
        $processed_content = htmlspecialchars($decoded_content, ENT_QUOTES, 'UTF-8');
        
        // Save the content to the file or database
        $file_path = 'privacy_policy.html';
        if (file_put_contents($file_path, $processed_content)) {
            echo "Privacy policy saved successfully.";
        } else {
            echo "Failed to save the privacy policy.";
        }
    } else {
        echo "No content received.";
    }
} else {
    echo "Invalid request method.";
}
?>
