<?php
header("Content-Type: application/json");

require_once 'config.php';

// Create connection
$conn = get_db_connection();

// Check connection
if ($conn->connect_error) {
    die(json_encode(['status' => 'error', 'message' => 'Connection failed: ' . $conn->connect_error]));
}

// Read raw input from the request
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Check if the title and message exist in the decoded data
$title = isset($data['title']) ? trim($data['title']) : '';
$message = isset($data['message']) ? trim($data['message']) : '';

// Log received data for debugging
file_put_contents('debug_log.txt', "Received Title: " . $title . "\n", FILE_APPEND);
file_put_contents('debug_log.txt', "Received Message: " . $message . "\n", FILE_APPEND);

// Fetch all FCM tokens from the database
$query = "SELECT fcmToken FROM user_data WHERE fcmToken IS NOT NULL";
$result = $conn->query($query);

$fcm_tokens = array(); // Collect all FCM tokens
while ($row = $result->fetch_assoc()) {
    $fcm_tokens[] = $row['fcmToken'];
}

if (count($fcm_tokens) > 0) {
    // Fetch OAuth token from the Google service account
    $access_token = getAccessToken(); // Custom function to get OAuth token

    if (!$access_token) {
        die(json_encode(['status' => 'error', 'message' => 'Failed to get OAuth token']));
    }

    // Loop through each token and send notification
    $url = 'https://fcm.googleapis.com/v1/projects/gopalganj-96601/messages:send';
    foreach ($fcm_tokens as $token) {
        $fields = array(
            'message' => array(
                'token' => $token,
                'notification' => array(
                    'title' => $title,
                    'body' => $message
                ),
                'data' => array( // Adding the data payload
                    'title' => $title,
                    'message' => $message
                ),
                'android' => array(
                    'priority' => 'high'
                )
            )
        );

        $headers = array(
            'Authorization: Bearer ' . $access_token,
            'Content-Type: application/json'
        );

        // Send the notification via cURL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $result_curl = curl_exec($ch);
        curl_close($ch);

        // Log the result
        file_put_contents('debug_log.txt', "Notification Response for Token ($token): " . $result_curl . "\n", FILE_APPEND);
    }

    echo json_encode(['status' => 'success', 'message' => 'Notifications sent successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No FCM tokens found']);
}

$conn->close();

// Function to fetch OAuth 2.0 access token using the service account key
function getAccessToken() {
    $key_file_location = 'service-account-file.json'; // Path to your service account key file
    $scope = 'https://www.googleapis.com/auth/firebase.messaging';

    // Load the service account key
    $credentials = json_decode(file_get_contents($key_file_location), true);
    $jwt = generateJWT($credentials, $scope);

    // Get OAuth 2.0 token using JWT
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://oauth2.googleapis.com/token');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array(
        'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
        'assertion' => $jwt
    )));
    $response = curl_exec($ch);
    curl_close($ch);

    if ($response) {
        $data = json_decode($response, true);
        return $data['access_token'] ?? null;
    }

    return null;
}

// Function to generate a JWT (JSON Web Token)
function generateJWT($credentials, $scope) {
    $header = json_encode([
        'alg' => 'RS256',
        'typ' => 'JWT'
    ]);

    $now = time();
    $claims = json_encode([
        'iss' => $credentials['client_email'],
        'scope' => $scope,
        'aud' => 'https://oauth2.googleapis.com/token',
        'iat' => $now,
        'exp' => $now + 3600
    ]);

    $header = base64UrlEncode($header);
    $claims = base64UrlEncode($claims);

    $signature = '';
    openssl_sign("$header.$claims", $signature, $credentials['private_key'], 'SHA256');

    return "$header.$claims." . base64UrlEncode($signature);
}

// Function to base64 URL encode data
function base64UrlEncode($data) {
    return str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($data));
}
?>
