<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $postData = file_get_contents("php://input");
    $data = json_decode($postData, true);

    $email = isset($data['email']) ? $data['email'] : '';
    $phone = isset($data['phone']) ? $data['phone'] : '';
    $name = isset($data['name']) ? $data['name'] : '';
    $address = isset($data['address']) ? $data['address'] : '';
    $baseUrl = isset($data['base_url']) ? $data['base_url'] : '';
    $image64 = isset($data['image']) ? $data['image'] : '';
    $imageUrl = '';

    $connect = get_db_connection();
    if (!$connect) {
        echo json_encode(array('status' => 'error', 'message' => 'Database Connection Failed: ' . mysqli_connect_error()));
        exit();
    }

    // Handle image upload if provided
    if (!empty($image64)) {
        $decodedImage = base64_decode($image64);
        $fileName = time() . '_' . rand(1000, 100000) . '.jpg';
        $filePath = 'images/' . $fileName;

        if (file_put_contents($filePath, $decodedImage)) {
            $imageUrl = $baseUrl . $filePath;
        } else {
            echo json_encode(array('status' => 'error', 'message' => 'Image Upload Failed'));
            exit();
        }
    }

    // Fetch current user data
    $fetch_query = "SELECT * FROM user_data WHERE email = '$email'";
    $fetch_result = mysqli_query($connect, $fetch_query);
    $user_data = mysqli_fetch_assoc($fetch_result);

    if (!$user_data) {
        echo json_encode(array('status' => 'error', 'message' => 'User not found'));
        exit();
    }

    // Update only fields that are provided
    $name = !empty($name) ? $name : $user_data['name'];
    $phone = !empty($phone) ? $phone : $user_data['phone'];
    $address = !empty($address) ? $address : $user_data['address'];
    $imageUrl = !empty($imageUrl) ? $imageUrl : $user_data['image'];

    $update_query = "UPDATE user_data SET name = '$name', phone = '$phone', address = '$address', image = '$imageUrl' WHERE email = '$email'";
    $result = mysqli_query($connect, $update_query);

    if ($result) {
        echo json_encode(array('status' => 'success', 'message' => 'Profile Updated Successfully', 'image_url' => $imageUrl));
    } else {
        echo json_encode(array('status' => 'error', 'message' => 'Update Failed: ' . mysqli_error($connect)));
    }

    mysqli_close($connect);
}
?>
