<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $postData = file_get_contents("php://input");
    $data = json_decode($postData, true);

    // Logging request data for debugging
    error_log('Request received: ' . print_r($data, true));

    $email = isset($data['email']) ? $data['email'] : '';
    $newPassword = isset($data['new_password']) ? $data['new_password'] : '';

    // Validate email and password
    if (empty($email)) {
        echo json_encode(array('status' => 'error', 'message' => 'Email is missing'));
        exit();
    }

    if (empty($newPassword)) {
        echo json_encode(array('status' => 'error', 'message' => 'Password is missing'));
        exit();
    }

    // Database connection
    $connect = get_db_connection();
    if (!$connect) {
        echo json_encode(array('status' => 'error', 'message' => 'Database Connection Failed: ' . mysqli_connect_error()));
        exit();
    }

    // Sanitize email to prevent SQL injection
    $email = mysqli_real_escape_string($connect, $email);

    // Hash the new password
    $newPasswordHashed = password_hash($newPassword, PASSWORD_BCRYPT);

    // Sanitize hashed password to prevent SQL injection
    $newPasswordHashed = mysqli_real_escape_string($connect, $newPasswordHashed);

    // Update query
    $update_query = "UPDATE user_data SET password = '$newPasswordHashed' WHERE email = '$email'";
    $result = mysqli_query($connect, $update_query);

    if ($result) {
        echo json_encode(array('status' => 'success', 'message' => 'Password updated successfully'));
    } else {
        echo json_encode(array('status' => 'error', 'message' => 'Failed to update password: ' . mysqli_error($connect)));
    }

    mysqli_close($connect);
} else {
    echo json_encode(array('status' => 'error', 'message' => 'Invalid Request'));
}

?>
