<?php
// Include the database configuration file
require_once 'config.php';

// Get the database connection
$conn = get_db_connection();

// Check if the connection was successful
if ($conn->connect_error) {
    die(json_encode(["error" => true, "message" => "Connection failed: " . $conn->connect_error]));
}

// Define the upload directory
$upload_dir = "sliderimage/";
$response = array();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_FILES['image']['name']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        // Sanitize and generate a unique name for the uploaded file
        $image_name = uniqid() . "_" . basename($_FILES["image"]["name"]);
        $target_file = $upload_dir . $image_name;

        // Move the uploaded file to the target directory
        if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
            // Construct the image link using BASE_URL
            $image_link = BASE_URL . $target_file;

            // Insert the image link into the database
            $stmt = $conn->prepare("INSERT INTO slider_image (image_link) VALUES (?)");
            $stmt->bind_param("s", $image_link);

            if ($stmt->execute()) {
                $response['error'] = false;
                $response['message'] = "Image uploaded successfully";
                $response['image_url'] = $image_link;
            } else {
                $response['error'] = true;
                $response['message'] = "Failed to insert image link into the database: " . $stmt->error;
            }

            $stmt->close();
        } else {
            $response['error'] = true;
            $response['message'] = "Failed to upload the image";
        }
    } else {
        $response['error'] = true;
        $response['message'] = "Image not found or an error occurred during upload";
    }
} else {
    $response['error'] = true;
    $response['message'] = "Invalid request method";
}

// Return the response as JSON
echo json_encode($response);

// Close the database connection
$conn->close();
?>
